# Install Docker

```shell
curl -q -LSsf https://get.docker.com | bash && usermod -aG docker $USER
```

# Setup incus

## Ipstall apt key
```shell
curl -fsSL https://pkgs.zabbly.com/key.asc -o /etc/apt/keyrings/zabbly.asc
```

## Create repo file

```shell
cat <<EOF | tee /etc/apt/sources.list.d/incus.sources
Enabled: yes
Types: deb
URIs: https://pkgs.zabbly.com/incus/stable
Suites: $(. /etc/os-release && echo ${VERSION_CODENAME})
Components: main
Architectures: $(dpkg --print-architecture)
Signed-By: /etc/apt/keyrings/zabbly.asc
 
EOF
```

## Install packages

```shell
apt update
apt install --ignore-missing -yy incus incus-ui-canonical btrfs-progs
```

## Add user to incus group

```shell
usermod -a -G incus-admin $USER && reboot
```

## Init incus

```shell
incus admin init
```

---

# Install libvirt/qemu

```shell
if grep -q -iE 'vmx|svm' /proc/cpuinfo; then
apt install --ignore-missing -yy qemu-kvm qemu-system qemu-utils libvirt-clients libvirt-daemon-system bridge-utils virtinst libvirt-daemon python3 python3-pip && \
  systemctl enable libvirtd
fi
```

## Setup networking

```shell
sudo virsh net-start default
sudo virsh net-autostart default
```

## Add user to kvm groups

```shell
usermod -aG libvirt,kvm,libvirt-qemu,input,disk $USER
```

## WebUI

```shell
apt install -y python3-pip pkg-config libnl-route-3-dev
pip3 install -r https://raw.githubusercontent.com/kimchi-project/kimchi/master/requirements-UBUNTU.txt
 ```

```shell
curl -q -LSsf https://github.com/kimchi-project/wok/releases/download/3.0.0/wok-3.0.0-0.debian.noarch.deb -o /tmp/wok.deb
curl -q -LSsf https://github.com/kimchi-project/kimchi/releases/download/3.0.0/kimchi-3.0.0-0.noarch.deb -o /tmp/kimchi.deb
apt install -y /tmp/wok.deb /tmp/kimchi.deb
```

