# Install Docker

```shell
curl -q -LSsf https://get.docker.com | bash && usermod -aG docker $USER
```

# Setup incus

## Ipstall apt key
```shell
curl -fsSL https://pkgs.zabbly.com/key.asc -o /etc/apt/keyrings/zabbly.asc
```

## Create repo file

```shell
cat <<EOF | tee /etc/apt/sources.list.d/incus.sources
Enabled: yes
Types: deb
URIs: https://pkgs.zabbly.com/incus/stable
Suites: $(. /etc/os-release && echo ${VERSION_CODENAME})
Components: main
Architectures: $(dpkg --print-architecture)
Signed-By: /etc/apt/keyrings/zabbly.asc
 
EOF
```

## Install packages

```shell
apt update
apt install --ignore-missing -yy incus incus-ui-canonical btrfs-progs
```

## Add user to incus group

```shell
usermod -a -G incus-admin $USER && reboot
```

## Init incus

```shell
incus admin init
```

---

# Install libvirt/qemu

```shell
if grep -q -iE 'vmx|svm' /proc/cpuinfo; then
apt install --ignore-missing -yy qemu-kvm qemu-system qemu-utils libvirt-clients libvirt-daemon-system bridge-utils virtinst libvirt-daemon python3 python3-pip && \
  systemctl enable libvirtd
fi
```

## Add user to kvm groups

```shell
usermod -aG libvirt,kvm,libvirt-qemu,input,disk $USER && sleep 5 && reboot
```

## Setup networking

```shell
sudo virsh net-start default
sudo virsh net-autostart default
```
