## Set password

```shell
echo "blueonyx" | passwd --stdin root
```

## Disable selinux 

```shell
sed -i 's/^SELINUX=.*/SELINUX=disabled/g' /etc/selinux/config
sed -i 's/^GRUB_ENABLE_BLSCFG=.*/GRUB_ENABLE_BLSCFG=false/g' /etc/default/grub
rm -Rf /boot/loader/entries/*
```

## Enable old style network

```shell
vi /etc/default/grub
```
```text
biosdevname=0 net.ifnames=0
```
```shell
grub2-mkconfig -o /boot/grub2/grub.cfg && reboot
```

## Install blueonyx

```shell
if yum install -yy http://devel.blueonyx.it/pub/5211R.rpm; then
  if yum groupinstall -yy blueonyx;then
    yum clean all
    if yum update -yy; then
      sh /usr/sausalito/scripts/initServices.sh
    else 
      exitStatus=1
    fi
  else 
     exitStatus=1
  fi
else
  exitStatus=1
fi
if [ -z "$exitStatus" ]; then
  echo "bluonyx has been installed"
fi
```

## Install epel repo

```shell 
dnf install -y epel-release
dnf config-manager --enable crb
```

## Install vnstat

```shell 
yum install -y vnstat && systemctl enable --now vnstat
```

## Update the system

```shell
dnf update -y && reboot
```

## Install kernel-ml

```shell
rpm --import https://www.elrepo.org/RPM-GPG-KEY-elrepo.org
yum install -y https://www.elrepo.org/elrepo-release-9.el9.elrepo.noarch.rpm
yum --enablerepo=elrepo-kernel install -y kernel-ml
if curl -q -LSsf "https://github.com/casjay-base/centos/raw/main/root/.local/bin/run-os-update" | bash -s -- --grub; then 
  yum update -y && sleep 5 && reboot
fi
```

## Install needed apps

```shell
dnf install -y git wget curl certbot python3-certbot-dns-rfc2136
```

## Install incus

```shell
dnf copr enable -y yneil/incus
dnf install -y incus incus-tools
```

## Setup incus

```shell 
echo "0:1000000:1000000000" | sudo tee /etc/subuid /etc/subgid >/dev/null
systemctl enable --now incus
incus admin init && reboot
```

## Install docker

```shell
sudo dnf config-manager -y --add-repo=https://download.docker.com/linux/centos/docker-ce.repo
sudo dnf install -y docker-ce docker-ce-cli containerd.io
sudo systemctl enable --now docker && reboot
```

## disable firewall

```
systemctl disable --now firewalld
```

## mandatory reboot

```shell
reboot 
```

## Install system scripts

```shell
export SCRIPTS_DIR="/usr/local/share/CasjaysDev/scripts"
if [ -d  "$SCRIPTS_DIR" ]; then
  echo "updating $SCRIPTS_DIR"
  git -C "$SCRIPTS_DIR" pull -q
else
  echo cloning "https://github.com/casjay-dotfiles/scripts >$SCRIPTS_DIR" &&
  git clone -q https://github.com/casjay-dotfiles/scripts "$SCRIPTS_DIR"
fi && eval "$SCRIPTS_DIR/install.sh" && reboot
```

## Default login

Username: root  
Password: blueonyx  
